//
//  Check.h
//  Sinc
//
//  Created by 杉浦 洋 on 2018/04/03.
//  Copyright © 2018年 杉浦 洋. All rights reserved.
//

#ifndef Check_h
#define Check_h
/*-------------------------------------------------------------------*/
/*　表関数のチェック関数　　　　　　　　　　　　　　　　　　　　　　　　　　　　    */
/*　　　・最大誤差：表の値をMathematicaで計算したものと比較して，最大誤差を計算 　*/
/*　　　・最大残差：表の値(100α%点)を方程式に代入して，最大残差を計算　　　　　　  */
/*　　　・表の印刷：引数 prn ≠ 0 のとき，表を印刷．　　　　　　　　　　　　　　   */
/*-------------------------------------------------------------------*/
//-----------------------FTab(T1型表)----------------------------
int Check_FTab(int prn){
    int M,l;
    double ermax,rsmax,**tab;
    int k=10,m=20;
    double al=0.05;
    double tabM[9][9]={{4.3512435033292896,1.0000000000000000,1.0000000000000000,1.0000000000000000,1.0000000000000000,1.0000000000000000,1.0000000000000000,1.0000000000000000,1.0000000000000000},{1.0000000000000000,3.4928284767356321,1.0000000000000000,1.0000000000000000,1.0000000000000000,1.0000000000000000,1.0000000000000000,1.0000000000000000,1.0000000000000000},{5.8422859859869636,1.0000000000000000,3.0983912121407795,1.0000000000000000,1.0000000000000000,1.0000000000000000,1.0000000000000000,1.0000000000000000,1.0000000000000000},{6.3546182068243384,4.1855243493326899,1.0000000000000000,2.8660814020156589,1.0000000000000000,1.0000000000000000,1.0000000000000000,1.0000000000000000,1.0000000000000000},{6.7846386980922846,4.4428419884187820,3.5282871482212594,1.0000000000000000,2.7108898372096908,1.0000000000000000,1.0000000000000000,1.0000000000000000,1.0000000000000000},{7.1561764680323092,4.6645282347772765,3.6964813128202723,3.1697906374244864,1.0000000000000000,2.5989777115642019,1.0000000000000000,1.0000000000000000,1.0000000000000000},{7.4838969205597516,4.8596242188537246,3.8443072161870293,3.2930293023004440,2.9420799751140283,1.0000000000000000,2.5140110629988337,1.0000000000000000,1.0000000000000000},{7.7774938294489271,5.0340783904278101,3.9763487884948185,3.4030238782522924,3.0384611502738119,2.7837537534681673,1.0000000000000000,2.4470637479798225,1.0000000000000000},{8.0437220507882969,5.1920203210281990,4.0957820916051402,3.5024498348394060,3.1255373940167503,2.8624056155046169,2.6668521444602047,1.0000000000000000,2.3928141084422796}};
    printf("--------------------Check FTab--------------------\n");
    tab=FTab(k,m,al);
    
    //print error
    ermax=0;rsmax=0;
    for(M=2;M<=k;M++){
        for(l=2;l<=M;l++){
            if(l != M-1){
                ermax=fmax(ermax,fabs(tab[M][l]-tabM[M-2][l-2]));
                rsmax=fmax(rsmax,fabs(FCDF(tab[M][l],l-1,m)-(1-alMl(al,M,l))));
            };
        };
    };
    printf("最大誤差 = %e      最大残差 = %e\n",ermax,rsmax);
    //表印刷　prn!=0なら．
    if(prn!=0) PrintTabT1(k,tab);
    return 0;
};
//-----------------------chi2Tab(T1型表)----------------------------
int Check_chi2Tab(int prn){
    int M,l;
    double ermax,rsmax,**tab;
    int k=10;
    double al=0.05;
    double tabM[9][9]={{3.8414588206941249,1.0000000000000000,1.0000000000000000,1.0000000000000000,1.0000000000000000,1.0000000000000000,1.0000000000000000,1.0000000000000000,1.0000000000000000},{1.0000000000000000,5.9914645471079799,1.0000000000000000,1.0000000000000000,1.0000000000000000,1.0000000000000000,1.0000000000000000,1.0000000000000000,1.0000000000000000},{5.0018277816524774,1.0000000000000000,7.8147279032511783,1.0000000000000000,1.0000000000000000,1.0000000000000000,1.0000000000000000,1.0000000000000000,1.0000000000000000},{5.3851991774742984,6.9927387928103544,1.0000000000000000,9.4877290367811540,1.0000000000000000,1.0000000000000000,1.0000000000000000,1.0000000000000000,1.0000000000000000},{5.7012922173534024,7.3522766941557389,8.6960396087506773,1.0000000000000000,11.070497693516351,1.0000000000000000,1.0000000000000000,1.0000000000000000,1.0000000000000000},{5.9703537745176130,7.6569287890331790,9.0307317893128172,10.279415457328335,1.0000000000000000,12.591587243743977,1.0000000000000000,1.0000000000000000,1.0000000000000000},{6.2046581899400808,7.9212531575429104,9.3204200874506142,10.592237102865308,11.792832822750901,1.0000000000000000,14.067140449340167,1.0000000000000000,1.0000000000000000},{6.4122152534320316,8.1546884791456602,9.5757385433998330,10.867508971633768,12.086808552083614,13.258519577304424,1.0000000000000000,15.507313055865451,1.0000000000000000},{6.5985442133319507,8.3637043625760317,9.8039528625161054,11.113224833542137,12.348922878847999,13.536224562037633,14.688651090212220,1.0000000000000000,16.918977604620448}};
    printf("--------------------Check chi2Tab--------------------\n");
    tab=chi2Tab(k,al);
    
    //print error
    ermax=0;rsmax=0;
    for(M=2;M<=k;M++){
        for(l=2;l<=M;l++){
            if(l != M-1){
                ermax=fmax(ermax,fabs(tab[M][l]-tabM[M-2][l-2]));
                rsmax=fmax(rsmax,fabs(chi2CDF(tab[M][l],l-1)-(1-alMl(al,M,l))));
            };
        };
    };
    printf("最大誤差 = %e      最大残差 = %e\n",ermax,rsmax);
    //表印刷　prn!=0なら．
    if(prn!=0) PrintTabT1(k,tab);
    return 0;
};
//-----------------------zTab(T1型表)----------------------------
int Check_zTab(int prn){
    int M,l;
    double ermax,rsmax,**tab;
    int k=10;
    double al=0.05;
    double tabM[9][9]={{1.6448536269514722,1.0000000000000000,1.0000000000000000,1.0000000000000000,1.0000000000000000,1.0000000000000000,1.0000000000000000,1.0000000000000000,1.0000000000000000},{1.0000000000000000,1.6448536269514722,1.0000000000000000,1.0000000000000000,1.0000000000000000,1.0000000000000000,1.0000000000000000,1.0000000000000000,1.0000000000000000},{1.9545083272139914,1.0000000000000000,1.6448536269514722,1.0000000000000000,1.0000000000000000,1.0000000000000000,1.0000000000000000,1.0000000000000000,1.0000000000000000},{2.0474233114081919,1.8762975387874725,1.0000000000000000,1.6448536269514722,1.0000000000000000,1.0000000000000000,1.0000000000000000,1.0000000000000000,1.0000000000000000},{2.1212014296805064,1.9545083272139914,1.8301003111467560,1.0000000000000000,1.6448536269514722,1.0000000000000000,1.0000000000000000,1.0000000000000000,1.0000000000000000},{2.1821735905246684,2.0190121442327489,1.8974381271151808,1.7994341510327458,1.0000000000000000,1.6448536269514722,1.0000000000000000,1.0000000000000000,1.0000000000000000},{2.2340024752250125,2.0737520230895012,1.9545083272139914,1.8584877750322033,1.7775438700700494,1.0000000000000000,1.6448536269514722,1.0000000000000000,1.0000000000000000},{2.2789912414876188,2.1212014296805064,2.0039234403068491,1.9095733407406912,1.8301003111467560,1.7611150560362852,1.0000000000000000,1.6448536269514722,1.0000000000000000},{2.3186792098264086,2.1630101836682614,2.0474233114081919,1.9545083272139914,1.8762975387874725,1.8084485776133645,1.7483223381501181,1.0000000000000000,1.6448536269514722}};
    printf("--------------------Check zTab--------------------\n");
    tab=zTab(k,al);
    
    //print error
    ermax=0;rsmax=0;
    for(M=2;M<=k;M++){
        for(l=2;l<=M;l++){
            if(l != M-1){
                ermax=fmax(ermax,fabs(tab[M][l]-tabM[M-2][l-2]));
                rsmax=fmax(rsmax,fabs(PhiCDF(1,tab[M][l])-(1-alMl(al,M,l))));
            };
        };
    };
    printf("最大誤差 = %e      最大残差 = %e\n",ermax,rsmax);
    //表印刷　prn!=0なら．
    if(prn!=0) PrintTabT1(k,tab);
    return 0;
};
//-----------------------tTab(T1型表)----------------------------
int Check_tTab(int prn){
    int M,l;
    double ermax,rsmax,**tab;
    int k=10,m=20;
    double al=0.05;
    double tabM[9][9]={{1.7247182429207859,1.0000000000000000,1.0000000000000000,1.0000000000000000,1.0000000000000000,1.0000000000000000,1.0000000000000000,1.0000000000000000,1.0000000000000000},{1.0000000000000000,1.7247182429207859,1.0000000000000000,1.0000000000000000,1.0000000000000000,1.0000000000000000,1.0000000000000000,1.0000000000000000,1.0000000000000000},{2.0795720935375264,1.0000000000000000,1.7247182429207859,1.0000000000000000,1.0000000000000000,1.0000000000000000,1.0000000000000000,1.0000000000000000,1.0000000000000000},{2.1891416648412032,1.9885052585704395,1.0000000000000000,1.7247182429207859,1.0000000000000000,1.0000000000000000,1.0000000000000000,1.0000000000000000,1.0000000000000000},{2.2772699377994003,2.0795720935375264,1.9351905109836607,1.0000000000000000,1.7247182429207859,1.0000000000000000,1.0000000000000000,1.0000000000000000,1.0000000000000000},{2.3508900303326281,2.1554737720344108,2.0130194126054586,1.8999883628420422,1.0000000000000000,1.7247182429207859,1.0000000000000000,1.0000000000000000,1.0000000000000000},{2.4140531731924697,2.2204741856943269,2.0795720935375264,1.9679105692351426,1.8749502466474599,1.0000000000000000,1.7247182429207859,1.0000000000000000,1.0000000000000000},{2.4693287651441871,2.2772699377994003,2.1376527164570822,2.0271247590640824,1.9351905109836607,1.8562074759877989,1.0000000000000000,1.7247182429207859,1.0000000000000000},{2.5184470475015446,2.3276726654485378,2.1891416648412032,2.0795720935375264,1.9885052585704395,1.9103207720719297,1.8416414098832337,1.0000000000000000,1.7247182429207859}};
    printf("--------------------Check tTab--------------------\n");
    tab=tTab(k,m,al);
    
    //print error
    ermax=0;rsmax=0;
    for(M=2;M<=k;M++){
        for(l=2;l<=M;l++){
            if(l != M-1){
                ermax=fmax(ermax,fabs(tab[M][l]-tabM[M-2][l-2]));
                rsmax=fmax(rsmax,fabs(tCDF(tab[M][l],m)-(1-alMl(al,M,l))));
            };
        };
    };
    printf("最大誤差 = %e      最大残差 = %e\n",ermax,rsmax);
    //表印刷　prn!=0なら．
    if(prn!=0) PrintTabT1(k,tab);
    return 0;
};
//-----------------------aTab(T1型表)----------------------------
int Check_aTab(int prn){
    int M,l;
    double ermax,rsmax,**tab;
    int k=10;
    double al=0.05;
    double tabM[9][9]={{1.9599639845400518,1.0000000000000000,1.0000000000000000,1.0000000000000000,1.0000000000000000,1.0000000000000000,1.0000000000000000,1.0000000000000000,1.0000000000000000},{1.0000000000000000,2.3437005863784077,1.0000000000000000,1.0000000000000000,1.0000000000000000,1.0000000000000000,1.0000000000000000,1.0000000000000000,1.0000000000000000},{2.2364766445577877,1.0000000000000000,2.5690317725464831,1.0000000000000000,1.0000000000000000,1.0000000000000000,1.0000000000000000,1.0000000000000000,1.0000000000000000},{2.3206031925933153,2.5341009981482849,1.0000000000000000,2.7277743708703763,1.0000000000000000,1.0000000000000000,1.0000000000000000,1.0000000000000000,1.0000000000000000},{2.3877378870708057,2.5992016540612215,2.7141068979052227,1.0000000000000000,2.8497054196100007,1.0000000000000000,1.0000000000000000,1.0000000000000000,1.0000000000000000},{2.4434307386372929,2.6531670176288520,2.7673918144268135,2.8446778892909981,1.0000000000000000,2.9483200175296722,1.0000000000000000,1.0000000000000000,1.0000000000000000},{2.4909151310191362,2.6991528050589144,2.8127747724442269,2.8897561843816386,2.9473941356915772,1.0000000000000000,3.0308784496144154,1.0000000000000000,1.0000000000000000},{2.5322352286926169,2.7391514159353334,2.8522328515317596,2.9289351987152514,2.9864165790401520,3.0320763900196357,1.0000000000000000,3.1017303413033797,1.0000000000000000},{2.5687631680113929,2.7744988271028159,2.8870907310948386,2.9635360386229639,3.0208698221182622,3.0664427194382364,3.1040806067301552,1.0000000000000000,3.1636835770533662}};
    printf("--------------------Check aTab--------------------\n");
    tab=aTab(k,al);
    
    //print error
    ermax=0;rsmax=0;
    for(M=2;M<=k;M++){
        for(l=2;l<=M;l++){
            if(l != M-1){
                ermax=fmax(ermax,fabs(tab[M][l]-tabM[M-2][l-2]));
                rsmax=fmax(rsmax,fabs(ACDF(tab[M][l],l)-(1-alMl(al,M,l))));
            };
        };
    };
    printf("最大誤差 = %e      最大残差 = %e\n",ermax,rsmax);
    //表印刷　prn!=0なら．
    if(prn!=0) PrintTabT1(k,tab);
    return 0;
};
//-----------------------taTab(T1型表)----------------------------
int Check_taTab(int prn){
    int M,l;
    double ermax,rsmax,**tab;
    int k=10,m=60;
    double al=0.05;
    double tabM[9][9]={{2.0002978220142587,1.0000000000000000,1.0000000000000000,1.0000000000000000,1.0000000000000000,1.0000000000000000,1.0000000000000000,1.0000000000000000,1.0000000000000000},{1.0000000000000000,2.4032164102323632,1.0000000000000000,1.0000000000000000,1.0000000000000000,1.0000000000000000,1.0000000000000000,1.0000000000000000,1.0000000000000000},{2.2937775565156397,1.0000000000000000,2.6425211333458964,1.0000000000000000,1.0000000000000000,1.0000000000000000,1.0000000000000000,1.0000000000000000,1.0000000000000000},{2.3839462787471617,2.6093501815719917,1.0000000000000000,2.8124593961121165,1.0000000000000000,1.0000000000000000,1.0000000000000000,1.0000000000000000,1.0000000000000000},{2.4562189372219998,2.6804102800366998,2.8018077539387720,1.0000000000000000,2.9437992425811301,1.0000000000000000,1.0000000000000000,1.0000000000000000,1.0000000000000000},{2.5163942436372202,2.7395496390509382,2.8607182861610743,2.9422546005257155,1.0000000000000000,3.0505596385882283,1.0000000000000000,1.0000000000000000,1.0000000000000000},{2.5678623767873656,2.7901154911908908,2.9110698423518344,2.9926022799262486,3.0532782026216285,1.0000000000000000,3.1403171322574699,1.0000000000000000,1.0000000000000000},{2.6127730815544079,2.8342283348567001,2.9549826339766669,3.0364991215642765,3.0972380766999228,3.1451852725529794,1.0000000000000000,3.2176288961455524,1.0000000000000000},{2.6525731657098341,2.8733142403469967,2.9938817072473856,3.0753747088962120,3.1361607216800884,3.1841904841511921,3.2236104226981097,1.0000000000000000,3.2854471820151838}};
    printf("--------------------Check taTab--------------------\n");
    tab=taTab(k,m,al);
    
    //print error
    ermax=0;rsmax=0;
    for(M=2;M<=k;M++){
        for(l=2;l<=M;l++){
            if(l != M-1){
                ermax=fmax(ermax,fabs(tab[M][l]-tabM[M-2][l-2]));
                rsmax=fmax(rsmax,fabs(TACDF(tab[M][l],l,m)-(1-alMl(al,M,l))));
            };
        };
    };
    printf("最大誤差 = %e      最大残差 = %e\n",ermax,rsmax);
    //表印刷　prn!=0なら．
    if(prn!=0) PrintTabT1(k,tab);
    return 0;
};

//[6]
//-----------------------b1Tab(T2型表)----------------------------
int Check_b1Tab(int prn){
    int l,m;
    double ermax,rsmax,*tab;
    int k=10,n1=3,n2=3;
    double al=0.05;
    double lms[10];
    double tabM[9]={1.9599639845400529,2.2121277465786182,2.3489705903392668,2.4417707731976193,2.5114630534712563,2.5669966799384625,2.6130018458210049,2.6521757994904398,2.6862233673741329};
    printf("--------------------Check b1Tab--------------------\n");
    tab=b1Tab(k,n1,n2,al);
    // set lms[10] and m
    lms[0]=n1;
    for(l=1;l<k;l++) lms[l]=n2;
    m=n1+(k-1)*n2-k;
    //print error
    ermax=0;rsmax=0;
    for(l=1;l<k;l++){
        ermax=fmax(ermax,fabs(tab[l]-tabM[l-1]));
        rsmax=fmax(rsmax,fabs(B1CDF(tab[l],l+1,lms)-(1-al)));
    };
    printf("最大誤差 = %e      最大残差 = %e\n",ermax,rsmax);
    if(prn!=0) PrintTabT2(k,tab);
    return 0;
};
//-----------------------b2Tab(T2型表)----------------------------
int Check_b2Tab(int prn){
    int l,m;
    double ermax,rsmax,*tab;
    int k=10,n1=3,n2=3;
    double al=0.05;
    double lms[10];
    double tabM[9]={1.6448536269514724,1.9163319446876197,2.0620839329232092,2.1603332811555087,2.2338169608700142,2.2921938931591197,2.3404389763720110,2.3814401344260521,2.4170175245955989};
    printf("--------------------Check b2Tab--------------------\n");
    tab=b2Tab(k,n1,n2,al);
    // set lms[10] and m
    lms[0]=n1;
    for(l=1;l<k;l++) lms[l]=n2;
    m=n1+(k-1)*n2-k;
    //print error
    ermax=0;rsmax=0;
    for(l=1;l<k;l++){
        ermax=fmax(ermax,fabs(tab[l]-tabM[l-1]));
        rsmax=fmax(rsmax,fabs(B2CDF(tab[l],l+1,lms)-(1-al)));
    };
    printf("最大誤差 = %e      最大残差 = %e\n",ermax,rsmax);
    if(prn!=0) PrintTabT2(k,tab);
    return 0;
};
//-----------------------tb1Tab(T2型表)----------------------------
int Check_tb1Tab(int prn){
    int l,m;
    double ermax,rsmax,*tab;
    int k=10,n1=3,n2=3;
    double al=0.05;
    double lms[10];
    double tabM[9]={2.0859634472658617,2.3786899801813131,2.5403496099416447,2.6510295895727092,2.7346771574294042,2.8016402844288097,2.8573137315782406,2.9048584145140373,2.9462815061265966};
    printf("--------------------Check tb1Tab--------------------\n");
    tab=tb1Tab(k,n1,n2,al);
    // set lms[10] and m
    lms[0]=n1;
    for(l=1;l<k;l++) lms[l]=n2;
    m=n1+(k-1)*n2-k;
    //print error
    ermax=0;rsmax=0;
    for(l=1;l<k;l++){
        ermax=fmax(ermax,fabs(tab[l]-tabM[l-1]));
        rsmax=fmax(rsmax,fabs(TB1mCDF(tab[l],l+1,lms,m)-(1-al)));
    };
    printf("最大誤差 = %e      最大残差 = %e\n",ermax,rsmax);
    if(prn!=0) PrintTabT2(k,tab);
    return 0;
};
//-----------------------tb2Tab(T2型表)----------------------------
int Check_tb2Tab(int prn){
    int l,m;
    double ermax,rsmax,*tab;
    int k=10,n1=3,n2=3;
    double al=0.05;
    double lms[10];
    double tabM[9]={1.7247182429207819,2.0273183873666847,2.1922834623872429,2.3044275891963002,2.3887793845720191,2.4560699576497700,2.5118628861777870,2.5594041301443173,2.6007477910195713};
    tab=tb2Tab(k,n1,n2,al);
    printf("--------------------Check tb2Tab--------------------\n");
    // set lms[10] and m
    lms[0]=n1;
    for(l=1;l<k;l++) lms[l]=n2;
    m=n1+(k-1)*n2-k;
    //print error
    ermax=0;rsmax=0;
    for(l=1;l<k;l++){
        ermax=fmax(ermax,fabs(tab[l]-tabM[l-1]));
        rsmax=fmax(rsmax,fabs(TB2mCDF(tab[l],l+1,lms,m)-(1-al)));
    };
    printf("最大誤差 = %e      最大残差 = %e\n",ermax,rsmax);
    if(prn!=0) PrintTabT2(k,tab);
    return 0;
};
//[7]
//-----------------------d1Tab(T1型)----------------------------
int Check_d1Tab(int prn){
    int M,l;
    double ermax,rsmax,**tab;
    double k=10,al=0.05;
    double tabM[9][9]={{1.6448536269514731,1.0000000000000000,1.0000000000000000,1.0000000000000000,1.0000000000000000,1.0000000000000000,1.0000000000000000,1.0000000000000000,1.0000000000000000},{1.0000000000000000,2.0807707248699296,1.0000000000000000,1.0000000000000000,1.0000000000000000,1.0000000000000000,1.0000000000000000,1.0000000000000000,1.0000000000000000},{1.9545083272139914,1.0000000000000000,2.3294223493409003,1.0000000000000000,1.0000000000000000,1.0000000000000000,1.0000000000000000,1.0000000000000000,1.0000000000000000},{2.0474233114081919,2.2869585311105620,1.0000000000000000,2.5022425092979459,1.0000000000000000,1.0000000000000000,1.0000000000000000,1.0000000000000000,1.0000000000000000},{2.1212014296805086,2.3570704486872094,2.4842860253441064,1.0000000000000000,2.6338999101151774,1.0000000000000000,1.0000000000000000,1.0000000000000000,1.0000000000000000},{2.1821735905246697,2.4150527253592080,2.5409993759777385,2.6259846854365785,1.0000000000000000,2.7397795616948262,1.0000000000000000,1.0000000000000000,1.0000000000000000},{2.2340024752250116,2.4643675558940057,2.5892352752524754,2.6736150507529235,2.7367143214031397,1.0000000000000000,2.8280484493934739,1.0000000000000000,1.0000000000000000},{2.2789912414876183,2.5071940507037618,2.6311251293316666,2.7149749855776357,2.7777366649271058,2.8275619095047930,1.0000000000000000,2.9035532740872871,1.0000000000000000},{2.3186792098264091,2.5449896878342981,2.6680945132822727,2.7514736955566428,2.8139334666843538,2.8635518015076129,2.9045208134146976,1.0000000000000000,2.9694005290261765}};
    printf("--------------------Check d1Tab--------------------\n");
    tab=d1Tab(k,al);
    //print error
    ermax=0;rsmax=0;
    for(M=2;M<=k;M++){
        for(l=2;l<=M;l++){
            if(l != M-1){
                ermax=fmax(ermax,fabs(tab[M][l]-tabM[M-2][l-2]));
                rsmax=fmax(rsmax,fabs(D1CDF(tab[M][l],l)-(1-alMl(al,M,l))));
            };
        };
    };
    printf("最大誤差 = %e      最大残差 = %e\n",ermax,rsmax);
    //表印刷　prn!=0なら．
    if(prn!=0) PrintTabT1(k,tab);
    return 0;
};
//-----------------------d2Tab(T1)----------------------------
int Check_d2Tab(int prn){
    int M,l;
    double ermax,rsmax,**tab;
    double k=10,al=0.05;
    double tabM[9][9]={{1.6448536269514731,1.0000000000000000,1.0000000000000000,1.0000000000000000,1.0000000000000000,1.0000000000000000,1.0000000000000000,1.0000000000000000,1.0000000000000000},{1.0000000000000000,1.9599245290206424,1.0000000000000000,1.0000000000000000,1.0000000000000000,1.0000000000000000,1.0000000000000000,1.0000000000000000,1.0000000000000000},{1.9545083272139914,1.0000000000000000,2.1257749813322575,1.0000000000000000,1.0000000000000000,1.0000000000000000,1.0000000000000000,1.0000000000000000,1.0000000000000000},{2.0474233114081919,2.1660426738735197,1.0000000000000000,2.2377185432997138,1.0000000000000000,1.0000000000000000,1.0000000000000000,1.0000000000000000,1.0000000000000000},{2.1212014296805086,2.2364711355530846,2.2818821007091326,1.0000000000000000,2.3217618220891811,1.0000000000000000,1.0000000000000000,1.0000000000000000,1.0000000000000000},{2.1821735905246697,2.2948245404902243,2.3393159018777072,2.3633479212732147,1.0000000000000000,2.3887866881198274,1.0000000000000000,1.0000000000000000,1.0000000000000000},{2.2340024752250116,2.3445257147797984,2.3882625595628459,2.4119036024411651,2.4267457439518569,1.0000000000000000,2.4443762504455240,1.0000000000000000,1.0000000000000000},{2.2789912414876183,2.3877361682830740,2.4308373433252450,2.4541479346051327,2.4687868149076477,2.4788428134081308,1.0000000000000000,2.4917703905844313,1.0000000000000000},{2.3186792098264091,2.4259053660600776,2.4684600209470173,2.4914857596140134,2.5059491962366378,2.5158861184113905,2.5231369101972874,1.0000000000000000,2.5330131263939659}};
    printf("--------------------Check d2Tab--------------------\n");
    tab=d2Tab(k,al);
    
    //print error
    ermax=0;rsmax=0;
    for(M=2;M<=k;M++){
        for(l=2;l<=M;l++){
            if(l != M-1){
                ermax=fmax(ermax,fabs(tab[M][l]-tabM[M-2][l-2]));
                rsmax=fmax(rsmax,fabs(D2CDF(tab[M][l],l)-(1-alMl(al,M,l))));
            };
        };
    };
    printf("最大誤差 = %e      最大残差 = %e\n",ermax,rsmax);
    //表印刷　prn!=0なら．
    if(prn!=0) PrintTabT1(k,tab);
    return 0;
};
//-----------------------d3Tab(T3型表)----------------------------
int Check_d3Tab(int prn){
    int l;
    double ermax,rsmax,*tab;
    int k=10;
    double al=0.05;
    double tabM[9]={1.6448536269514731,1.7161856889526730,1.7389684882055974,1.7498404529104181,1.7561314296391033,1.7602105725897543,1.7630617892203115,1.7651635466481514,1.7667753927790337};
    printf("--------------------Check d3Tab--------------------\n");
    tab=d3Tab(k,al);
    //print error
    ermax=0;rsmax=0;
    for(l=2;l<=k;l++){
        ermax=fmax(ermax,fabs(tab[l]-tabM[l-2]));
        rsmax=fmax(rsmax,fabs(D3CDF(tab[l],l)-(1-al)));
    };
    printf("最大誤差 = %e      最大残差 = %e\n",ermax,rsmax);
    if(prn!=0) PrintTabT3(k,tab);
    return 0;
};
//-----------------------td1Tab(T1型表)----------------------------
int Check_td1Tab(int prn){
    int M,l;
    double ermax,rsmax,**tab;
    double k=10,m=60,al=0.05;
    double tabM[9][9]={{1.6706488649046343,1.0000000000000000,1.0000000000000000,1.0000000000000000,1.0000000000000000,1.0000000000000000,1.0000000000000000,1.0000000000000000,1.0000000000000000},{1.0000000000000000,2.1246174810859313,1.0000000000000000,1.0000000000000000,1.0000000000000000,1.0000000000000000,1.0000000000000000,1.0000000000000000,1.0000000000000000},{1.9945492650467294,1.0000000000000000,2.3866757844341446,1.0000000000000000,1.0000000000000000,1.0000000000000000,1.0000000000000000,1.0000000000000000,1.0000000000000000},{2.0926663006742059,2.3443855800497468,1.0000000000000000,2.5703328795285367,1.0000000000000000,1.0000000000000000,1.0000000000000000,1.0000000000000000,1.0000000000000000},{2.1709080439489190,2.4197146293094227,2.5539622384641825,1.0000000000000000,2.7111480110952626,1.0000000000000000,1.0000000000000000,1.0000000000000000,1.0000000000000000},{2.2358006329157711,2.4822533804885007,2.6156408051261706,2.7054336217943762,1.0000000000000000,2.8249874096579646,1.0000000000000000,1.0000000000000000,1.0000000000000000},{2.2911321922453638,2.5356205593971466,2.6682815328249538,2.7577401034577256,2.8244092049682883,1.0000000000000000,2.9203123035875946,1.0000000000000000,1.0000000000000000},{2.3392915398996603,2.5821011797102256,2.7141350071997685,2.8033013976559005,2.8698309437915812,2.9224421090527803,1.0000000000000000,3.0021641490199564,1.0000000000000000},{2.3818792414627001,2.6232278728478970,2.7547110618780661,2.8436181323951959,2.9100215385179622,2.9625788099926877,3.0057956752779620,1.0000000000000000,3.0737857604063081}};
    printf("--------------------Check td1Tab--------------------\n");
    tab=td1Tab(k,m,al);
    //print error
    ermax=0;rsmax=0;
    for(M=2;M<=k;M++){
        for(l=2;l<=M;l++){
            if(l != M-1){
                ermax=fmax(ermax,fabs(tab[M][l]-tabM[M-2][l-2]));
                rsmax=fmax(rsmax,fabs(TD1CDF(tab[M][l],l,m)-(1-alMl(al,M,l))));
            };
        };
    };
    printf("最大誤差 = %e      最大残差 = %e\n",ermax,rsmax);
    //表印刷　prn!=0なら．
    if(prn!=0) PrintTabT1(k,tab);
    return 0;
};
//-----------------------td2Tab(T1型表)----------------------------
int Check_td2Tab(int prn){
    int M,l;
    double ermax,rsmax,**tab;
    double k=10,m=60,al=0.05;
    double tabM[9][9]={{1.6706488649046343,1.0000000000000000,1.0000000000000000,1.0000000000000000,1.0000000000000000,1.0000000000000000,1.0000000000000000,1.0000000000000000,1.0000000000000000},{1.0000000000000000,2.0002073676159999,1.0000000000000000,1.0000000000000000,1.0000000000000000,1.0000000000000000,1.0000000000000000,1.0000000000000000,1.0000000000000000},{1.9945492650467294,1.0000000000000000,2.1751452667518620,1.0000000000000000,1.0000000000000000,1.0000000000000000,1.0000000000000000,1.0000000000000000,1.0000000000000000},{2.0926663006742059,2.2185920040105911,1.0000000000000000,2.2938954593069454,1.0000000000000000,1.0000000000000000,1.0000000000000000,1.0000000000000000,1.0000000000000000},{2.1709080439489190,2.2937575137423551,2.3418798176831830,1.0000000000000000,2.3834555981531356,1.0000000000000000,1.0000000000000000,1.0000000000000000,1.0000000000000000},{2.2358006329157711,2.3562593327861201,2.4035899977188131,2.4289034980943600,1.0000000000000000,2.4551499634378340,1.0000000000000000,1.0000000000000000,1.0000000000000000},{2.2911321922453638,2.4096585329286384,2.4563435352883420,2.4813459845395958,2.4968427622777640,1.0000000000000000,2.5148031857561670,1.0000000000000000,1.0000000000000000},{2.3392915398996603,2.4562103490344769,2.5023541150595423,2.5270948090789576,2.5424447595196509,2.5528278615687436,1.0000000000000000,2.5658034464419863,1.0000000000000000},{2.3818792414627001,2.4974309004409050,2.5431113437101032,2.5676272069299508,2.5828507419428313,2.5931577087358382,2.6005455717910078,1.0000000000000000,2.6102931278136232}};
    printf("--------------------Check td2Tab--------------------\n");
    tab=td2Tab(k,m,al);
    //print error
    ermax=0;rsmax=0;
    for(M=2;M<=k;M++){
        for(l=2;l<=M;l++){
            if(l != M-1){
                ermax=fmax(ermax,fabs(tab[M][l]-tabM[M-2][l-2]));
                rsmax=fmax(rsmax,fabs(TD2CDF(tab[M][l],l,m)-(1-alMl(al,M,l))));
            };
        };
    };
    printf("最大誤差 = %e      最大残差 = %e\n",ermax,rsmax);
    //表印刷　prn!=0なら．
    if(prn!=0) PrintTabT1(k,tab);
    return 0;
};
//-----------------------td3Tab(T3型表)----------------------------
int Check_td3Tab(int prn){
    int l;
    double ermax,rsmax,*tab;
    int k=10,m=60;
    double al=0.05;
    double tabM[9]={1.6706488649046343,1.7455066179104146,1.7696726110611916,1.7812810291805363,1.7880286822130833,1.7924184578369442,1.7954945601179879,1.7977666075436933,1.7995118536844279};
    printf("--------------------Check td3Tab--------------------\n");
    tab=td3Tab(k,m,al);
    //print error
    ermax=0;rsmax=0;
    for(l=2;l<=k;l++){
        ermax=fmax(ermax,fabs(tab[l]-tabM[l-2]));
        rsmax=fmax(rsmax,fabs(TD3CDF(tab[l],l,m)-(1-al)));
    };
    printf("最大誤差 = %e      最大残差 = %e\n",ermax,rsmax);
    if(prn!=0) PrintTabT3(k,tab);
    return 0;
};
//-----------------------bbarTab(T1型表)----------------------------
int Check_bbarTab(int prn){
    int M,l;
    double ermax,rsmax,**tab;
    double k=10,m=100,al=0.05;
    double tabM[9][9]={{2.7563780175117576,1.0000000000000000,1.0000000000000000,1.0000000000000000,1.0000000000000000,1.0000000000000000,1.0000000000000000,1.0000000000000000,1.0000000000000000},{1.0000000000000000,3.9049009868847739,1.0000000000000000,1.0000000000000000,1.0000000000000000,1.0000000000000000,1.0000000000000000,1.0000000000000000,1.0000000000000000},{3.9138382169635633,1.0000000000000000,4.6373221871473769,1.0000000000000000,1.0000000000000000,1.0000000000000000,1.0000000000000000,1.0000000000000000,1.0000000000000000},{4.3028809570796671,4.8676164321013902,1.0000000000000000,5.1769355090148634,1.0000000000000000,1.0000000000000000,1.0000000000000000,1.0000000000000000,1.0000000000000000},{4.6257627621592139,5.2192123134822923,5.4548739771787496,1.0000000000000000,5.6037407283837384,1.0000000000000000,1.0000000000000000,1.0000000000000000,1.0000000000000000},{4.9020155398005416,5.5193466320292179,5.7703824518654105,5.8874313196900525,1.0000000000000000,5.9562829381151756,1.0000000000000000,1.0000000000000000,1.0000000000000000},{5.1435923678404523,5.7813196440636290,6.0455486593892962,6.1724324258444296,6.2326006941354892,1.0000000000000000,6.2562166112520412,1.0000000000000000,1.0000000000000000},{5.3583495007415465,6.0138457790786672,6.2896113026794387,6.4251136085494487,6.4921622857416343,6.5209079782883261,1.0000000000000000,6.5169452443496700,1.0000000000000000},{5.5517315009681951,6.2229488252655560,6.5089516416107998,6.6521146928709030,6.7252872395442198,6.7591298779561013,6.7689687027259717,1.0000000000000000,6.7473461335586036}};
    double lms[10];
    printf("--------------------Check bbarTab--------------------\n");
    tab=bbarTab(k,m,al);
    // set lms
    for(l=0;l<k;l++) lms[l]=0;
    //print error
    ermax=0;rsmax=0;
    for(M=2;M<=k;M++){
        for(l=2;l<=M;l++){
            if(l != M-1){
                ermax=fmax(ermax,fabs(tab[M][l]-tabM[M-2][l-2]));
                rsmax=fmax(rsmax,fabs(bbar2Fun(l,lms,m,1-alMl(al,M,l))));
            };
        };
    };
    printf("最大誤差 = %e      最大残差 = %e\n",ermax,rsmax);
    if(prn!=0) PrintTabT1(k,tab);
    return 0;
};
//-----------------------cbarTab(T1型表)----------------------------
int Check_cbarTab(int prn){
    int M,l;
    double ermax,rsmax,**tab;
    double k=10,al=0.05;
    double tabM[9][9]={{2.7055434540954133,1.0000000000000000,1.0000000000000000,1.0000000000000000,1.0000000000000000,1.0000000000000000,1.0000000000000000,1.0000000000000000,1.0000000000000000},{1.0000000000000000,3.8200795387873265,1.0000000000000000,1.0000000000000000,1.0000000000000000,1.0000000000000000,1.0000000000000000,1.0000000000000000,1.0000000000000000},{3.8201028011488356,1.0000000000000000,4.5283256007645285,1.0000000000000000,1.0000000000000000,1.0000000000000000,1.0000000000000000,1.0000000000000000,1.0000000000000000},{4.1919422160976865,4.7404549252952863,1.0000000000000000,5.0490673882184192,1.0000000000000000,1.0000000000000000,1.0000000000000000,1.0000000000000000,1.0000000000000000},{4.4994955052786256,5.0745123728652883,5.3067430466688359,1.0000000000000000,5.4603614472247095,1.0000000000000000,1.0000000000000000,1.0000000000000000,1.0000000000000000},{4.7618815791833242,5.3588043163535506,5.6055732001842760,5.7236387145916661,1.0000000000000000,5.7997224967006664,1.0000000000000000,1.0000000000000000,1.0000000000000000},{4.9907670593114837,5.6062968492698477,5.8654821200637706,5.9929959950948009,6.0561297749906693,1.0000000000000000,6.0881890809495376,1.0000000000000000,1.0000000000000000},{5.1938010787772768,5.8254629679846097,6.0954596328349506,6.2312200862716498,6.3010410169467299,6.3336961636165539,1.0000000000000000,6.3387659633909488,1.0000000000000000},{5.3762732780812197,6.0221460426240681,6.3017001367132570,6.4447643336250522,6.5205161814413835,6.5581705018731595,6.5723899569306239,1.0000000000000000,6.5600570539399738}};
    double lms[10];
    printf("--------------------Check cbarTab--------------------\n");
    tab=cbarTab(k,al);
    // set lms
    for(l=0;l<k;l++) lms[l]=0;
    //print error
    ermax=0;rsmax=0;
    for(M=2;M<=k;M++){
        for(l=2;l<=M;l++){
            if(l != M-1){
                ermax=fmax(ermax,fabs(tab[M][l]-tabM[M-2][l-2]));
                rsmax=fmax(rsmax,fabs(cbar2Fun(l,lms,1-alMl(al,M,l))));
            };
        };
    };
    printf("最大誤差 = %e      最大残差 = %e\n",ermax,rsmax);
    if(prn!=0) PrintTabT1(k,tab);
    return 0;
};
//-----------------------bbar32Tab(T3型表)----------------------------
int Check_bbar32Tab(int prn){
    int l;
    double ermax,rsmax,*tab;
    int k=10,m=60;
    double al=0.05;
    double lms[10]={1.0000000000000000,2.0000000000000000,3.0000000000000000,4.0000000000000000,5.0000000000000000,6.0000000000000000,7.0000000000000000,8.0000000000000000,9.0000000000000000,10.000000000000000};
    double tabM[9]={2.7910676298070221,4.0169805594972852,4.8271269602891893,5.4406819656557737,5.9366077243094049,6.3534654387560598,6.7132635788837014,7.0298420319080321,7.3125054838976444};
    printf("--------------------Check bbar32Tab--------------------\n");
    //call function
    tab=bbar32Tab(k,lms,m,al);
    //print error
    ermax=0;rsmax=0;
    //print error
    ermax=0;rsmax=0;
    for(l=2;l<=k;l++){
        ermax=fmax(ermax,fabs(tab[l]-tabM[l-2]));
        rsmax=fmax(rsmax,fabs(BCDF(tab[l],l,lms,m)-(1-al)));
    };
    printf("最大誤差 = %e      最大残差 = %e\n",ermax,rsmax);
    if(prn!=0) PrintTabT3(k,tab);
    return 0;
};
//-----------------------cbar32Tab(T3型表)----------------------------
int Check_cbar32Tab(int prn){
    int l;
    double ermax,rsmax,*tab;
    int k=10;
    double al=0.05;
    double lms[10]={1.0000000000000000,2.0000000000000000,3.0000000000000000,4.0000000000000000,5.0000000000000000,6.0000000000000000,7.0000000000000000,8.0000000000000000,9.0000000000000000,10.000000000000000};
    double tabM[9]={2.7055434540954142,3.8709868074426623,4.6363523926318306,5.2138519487658153,5.6794115158217133,6.0699513051519869,6.4064780006650510,6.7021695456641179,6.9658680264256914};
    printf("--------------------Check cbar32Tab--------------------\n");
    //call function
    tab=cbar32Tab(k,lms,al);
    //print error
    ermax=0;rsmax=0;
    for(l=2;l<=k;l++){
        ermax=fmax(ermax,fabs(tab[l]-tabM[l-2]));
        rsmax=fmax(rsmax,CCDF(tab[l],l,lms)-(1-al));
    };
    printf("最大誤差 = %e      最大残差 = %e\n",ermax,rsmax);
    if(prn!=0) PrintTabT3(k,tab);
    return 0;
};
//-----------------------cbar32Tab(T3型表)付表30----------------------------
int Check_cbar32Tab30(int prn){
    int l;
    double ermax,rsmax,*tab;
    int k=10;
    double al=0.05;
    double lms[10]={1.0,1.0,1.0,1.0,1.0,1.0,1.0,1.0,1.0,1.0};
    double tabM[9]={2.7055434540954142,3.8200795387873274,4.5283256007645303,5.0490673882184200,5.4603614472247104,5.7997224967006673,6.0881890809495385,6.3387659633909497,6.5600570539399756};
    printf("--------------------Check cbar32Tab付表30-----------------\n");
    //call function
    tab=cbar32Tab(k,lms,al);
    //print error
    ermax=0;rsmax=0;
    for(l=2;l<=k;l++){
        ermax=fmax(ermax,fabs(tab[l]-tabM[l-2]));
        rsmax=fmax(rsmax,CCDF(tab[l],l,lms)-(1-al));
    };
    printf("最大誤差 = %e      最大残差 = %e\n",ermax,rsmax);
    if(prn!=0) PrintTabT3(k,tab);
    return 0;
};
// 全ての表関数をチェック
int Check_All(int prn){
    // [4]
    Check_zTab(prn);
    Check_chi2Tab(prn);
    Check_tTab(prn);
    Check_FTab(prn);
    // [5]
    Check_aTab(prn);
    Check_taTab(prn);
    // [6]
    Check_b1Tab(prn);
    Check_b2Tab(prn);
    Check_tb1Tab(prn);
    Check_tb2Tab(prn);
    
    // [7]
    Check_d1Tab(prn);
    Check_d2Tab(prn);
    Check_td1Tab(prn);
    Check_td2Tab(prn);
    Check_d3Tab(prn);
    Check_td3Tab(prn);
    // [9]
    Check_bbarTab(prn);
    Check_cbarTab(prn);
    Check_bbar32Tab(prn);
    Check_cbar32Tab(prn);
    return 0;
}

#endif /* Check_h */
